<?php
require_once '../config/config.php';
require_once '../includes/sorteo_logic.php';

$sorteoLogic = new SorteoLogic();
$ganador_config = $sorteoLogic->obtenerGanadorActivo();

$session_id = get_or_create_session_id();
$stmt = getDB()->prepare("SELECT * FROM configuracion_visual WHERE session_id = ? LIMIT 1");
$stmt->execute([$session_id]);
$config_visual = $stmt->fetch();

if (!$config_visual) {
    $stmt = getDB()->prepare("
        INSERT INTO configuracion_visual (session_id, tema_bolilla, color_fondo, color_numeros, tipo_animacion, velocidad, dificultad, idioma)
        VALUES (?, 'verde', '#000000', '#FFFFFF', 1, 1.8, 'medio', 'espanol')
    ");
    $stmt->execute([$session_id]);
    $stmt = getDB()->prepare("SELECT * FROM configuracion_visual WHERE session_id = ? LIMIT 1");
    $stmt->execute([$session_id]);
    $config_visual = $stmt->fetch();
}

$anuncios = [
    ['texto' => 'Gana hasta S/1,000 y disfruta descuentos en tus restaurantes favoritos', 'boton' => 'ABRIR', 'empresa' => 'Scotiabank', 'color' => '#DC0032'],
    ['texto' => 'Haz clic con oh! y obtén beneficios exclusivos al instante', 'boton' => 'Ver...', 'empresa' => 'oh! pay', 'color' => '#FF4500'],
    ['texto' => 'Consigue hasta 40% de descuento en tus compras online', 'boton' => 'IR', 'empresa' => 'Yape', 'color' => '#722F8E'],
    ['texto' => 'Pide tu delivery favorito y recibe cashback en tu primera orden', 'boton' => 'PEDIR', 'empresa' => 'Rappi', 'color' => '#FF4500'],
    ['texto' => 'Accede a créditos rápidos sin papeleos desde tu celular', 'boton' => 'SOLICITAR', 'empresa' => 'Mibanco', 'color' => '#00A859'],
];
$anuncio_inicial = $anuncios[0];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#000000">

    <!-- PWA Config -->
    <link rel="manifest" href="manifest.json">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Bolillero">

    <title>Bolillero</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            background: #000;
            color: #fff;
            user-select: none;
            overflow: hidden;
        }

        .app-container {
            background: <?php echo htmlspecialchars($config_visual['color_fondo']); ?>;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            position: relative;
        }

        /* Banner */
        .banner {
            background: #fff;
            padding: 12px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 12px;
            flex-shrink: 0;
            min-height: 60px;
            transition: all 0.5s ease;
        }

        .banner-left {
            display: flex;
            flex-direction: column;
            gap: 4px;
            flex: 1;
        }

        .banner-empresa {
            color: #333;
            font-weight: 700;
            font-size: 13px;
            letter-spacing: 0.3px;
        }

        .banner-text {
            color: #555;
            font-size: 10px;
            line-height: 1.3;
        }

        .banner-btn {
            background: #d32f2f;
            color: #fff;
            padding: 10px 20px;
            border-radius: 25px;
            border: none;
            font-size: 11px;
            font-weight: bold;
            cursor: pointer;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            transition: all 0.3s;
            white-space: nowrap;
        }

        .banner-btn:active {
            transform: scale(0.95);
        }

        /* Config Section */
        .config-section {
            padding: 12px 15px;
            position: relative;
            transition: opacity 0.3s, transform 0.3s;
        }

        .config-section.hidden {
            opacity: 0;
            transform: translateY(-20px);
            pointer-events: none;
            position: absolute;
            top: 60px;
        }

        /* Tuerca */
        .settings-icon {
            position: absolute;
            top: 12px;
            right: 15px;
            width: 36px;
            height: 36px;
            background: #1565C0;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 50;
            box-shadow: 0 3px 10px rgba(0,0,0,0.3);
            transition: transform 0.2s;
        }

        .settings-icon:active {
            transform: scale(0.9);
        }

        .settings-icon svg {
            width: 22px;
            height: 22px;
            fill: #fff;
        }

        /* Grid Config */
        .config-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
            margin-bottom: 12px;
        }

        .config-item {
            display: flex;
            flex-direction: column;
            gap: 3px;
        }

        .config-label {
            color: rgba(255,255,255,0.6);
            font-size: 11px;
            font-style: italic;
            text-align: center;
        }

        .config-box {
            background: transparent;
            border: 2px solid #fff;
            border-radius: 8px;
            padding: 3px 3px;
            text-align: center;
            cursor: pointer;
            min-height: 42px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
        }

        .config-box:active {
            transform: scale(0.95);
        }

        .config-box.active {
            border-color: #2196F3;
            background: rgba(33, 150, 243, 0.15);
            box-shadow: 0 0 20px rgba(33, 150, 243, 0.6);
        }

        .config-value {
            font-size: 20px;
            font-weight: bold;
            color: #fff;
        }

        /* Controls Row */
        .controls-row {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .limitar-container {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .limitar-text {
            color: rgba(255,255,255,0.6);
            font-size: 12px;
            font-style: italic;
        }

        .toggle {
            width: 46px;
            height: 24px;
            background: rgba(255,255,255,0.3);
            border-radius: 12px;
            position: relative;
            cursor: pointer;
            transition: background 0.3s;
            border: 2px solid rgba(255,255,255,0.2);
        }

        .toggle.active {
            background: #4caf50;
        }

        .toggle-knob {
            position: absolute;
            top: 2px;
            left: 2px;
            width: 16px;
            height: 16px;
            background: #fff;
            border-radius: 50%;
            transition: 0.3s;
            box-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .toggle.active .toggle-knob {
            left: 24px;
        }

        /* Botón Reiniciar */
        .btn-reiniciar {
            background: linear-gradient(to bottom, #2196f3 0%, #1976d2 50%, #1565c0 100%);
            color: white;
            border: none;
            padding: 5px 20px;
            border-radius: 30px;
            font-size: 20px;
            font-style: italic;
            cursor: pointer;
            box-shadow: 
                0 6px 0 #0d47a1,
                0 8px 20px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
            position: relative;
            top: 0;
            transition: all 0.1s;
        }

        .btn-reiniciar:hover {
            top: 2px;
            box-shadow: 
                0 4px 0 #0d47a1,
                0 6px 15px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
        }

        .btn-reiniciar:active {
            top: 6px;
            box-shadow: 
                0 0 0 #0d47a1,
                0 2px 10px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
        }

        /* Bolillero */
        .bolillero {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px 15px 100px;
            transition: padding 0.3s;
            position: relative;
        }

        .bolillero.expanded {
            padding: 80px 15px 100px;
        }

        .bolilla-container {
            width: 320px;
            height: 320px;
            position: relative;
            margin-bottom: 15px;
        }

        .bolilla {
            width: 260px;
            height: 260px;
            border-radius: 50%;
            background: radial-gradient(circle at 30% 30%, #7CFC00 0%, #32CD32 40%, #228B22 70%, #006400 100%);
            box-shadow:
                inset 10px 10px 30px rgba(0,0,0,0.4),
                inset -10px -10px 20px rgba(255,255,255,0.2),
                0 15px 40px rgba(0,255,0,0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            cursor: pointer;
            transition: transform 0.2s;
        }

        .bolilla:active {
            transform: translate(-50%, -50%) scale(0.95);
        }

        .bolilla::before {
            content: "";
            position: absolute;
            top: 10%;
            left: 25%;
            width: 40%;
            height: 30%;
            border-radius: 50%;
            background: radial-gradient(circle, rgba(255,255,255,0.9) 0%, transparent 70%);
            transform: rotate(-20deg);
            filter: blur(3px);
        }

        .bolilla-ring {
            position: absolute;
            width: 280px;
            height: 280px;
            border: 12px solid rgba(255,255,255,0.95);
            border-radius: 50%;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 
                inset 0 0 15px rgba(255,255,255,0.5),
                0 0 25px rgba(255,255,255,0.3);
        }

        .numero {
            font-size: 100px;
            font-weight: 900;
            color: #000;
            position: relative;
            z-index: 10;
        }

        @keyframes girarNumero {
            0% { transform: rotateY(0); opacity: 1; }
            50% { transform: rotateY(180deg); opacity: 0.2; }
            100% { transform: rotateY(360deg); opacity: 1; }
        }

        .numero.girando {
            animation: girarNumero 1.2s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        /* Mensaje Badge */
        .mensaje-badge {
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(20, 20, 20, 0.95);
            color: #fff;
            padding: 8px 20px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: bold;
            font-style: italic;
            white-space: nowrap;
            box-shadow: 0 4px 12px rgba(0,0,0,0.5);
            border: 1px solid rgba(255,255,255,0.1);
            z-index: 20;
            opacity: 0;
            transition: opacity 0.3s;
        }

        .mensaje-badge.visible {
            opacity: 1;
        }

        .descripcion {
            color: rgba(255,255,255,0.7);
            font-size: 12px;
            font-style: italic;
            text-align: center;
            margin-bottom: 15px;
            transition: opacity 0.3s;
            display: none;
        }

        /* Botón Automático */
        .btn-automatico {
            background: linear-gradient(to bottom, #2196f3 0%, #1976d2 50%, #1565c0 100%);
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 30px;
            font-size: 12px;
            font-style: italic;
            cursor: pointer;
            box-shadow: 
                0 6px 0 #0d47a1,
                0 8px 20px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
            position: relative;
            top: 0;
            transition: all 0.1s;
        }

        .btn-automatico:active {
            top: 6px;
            box-shadow: 
                0 0 0 #0d47a1,
                0 2px 10px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
        }

        .btn-automatico.hidden {
            opacity: 0;
            transform: scale(0.8);
            pointer-events: none;
        }

        /* Contenedor de Ganadores - Fila Horizontal */
        .ganadores-fila {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            align-items: center;
            gap: 12px;
            margin-top: 30px;
            max-width: 90%;
            transition: opacity 0.3s;
            margin-left: auto;
            margin-right: auto;
        }

        .ganadores-fila.hidden {
            display: none;
        }

        /* Cada cuadro de ganador individual */
        .ganador-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            animation: aparecerGanador 0.5s ease;
        }

        @keyframes aparecerGanador {
            from {
                opacity: 0;
                transform: scale(0.2);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .ganador-item-label {
            color: #fff;
            font-size: 22px;
            font-style: italic;
            font-weight: 300;
            text-align: center;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
            white-space: nowrap;
        }

        .ganador-item-cuadro {
            background: transparent;
            border: 4px solid #fff;
            border-radius: 20px;
            padding: 10px 25px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.6);
            min-width: 70px;
        }

        .ganador-item-numero {
            font-size: 50px;
            font-weight: 900;
            color: #fff;
            text-align: center;
            line-height: 1;
        }

        /* Iconos Bottom */
        .icons-bottom {
            position: fixed;
            bottom: 15px;
            left: 15px;
            right: 15px;
            display: flex;
            justify-content: space-between;
            z-index: 100;
            transition: opacity 0.3s;
        }

        .icons-bottom.hidden {
            opacity: 0;
            pointer-events: none;
        }

        .icon-btn {
            width: 50px;
            height: 50px;
            background: rgba(70, 70, 70, 0.95);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            border: 1px solid rgba(255,255,255,0.1);
            transition: all 0.2s;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        }

        .icon-btn:active {
            transform: scale(0.9);
        }

        .icon-lapiz {
            font-size: 26px;
        }

        .icon-flecha {
            font-size: 32px;
            color: #888;
        }

        /* Panel Historial */
        .panel-historial {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(128, 128, 128, 0.98);
            z-index: 300;
            display: none;
            flex-direction: column;
        }

        .panel-historial.active {
            display: flex;
        }

        .historial-header {
            background: #000;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .historial-header h3 {
            color: #fff;
            font-size: 15px;
        }

        .btn-close-historial {
            background: none;
            border: none;
            color: #fff;
            font-size: 30px;
            cursor: pointer;
            line-height: 1;
        }

        .historial-content {
            flex: 1;
            padding: 12px;
            overflow-y: auto;
        }

        .historial-item {
            background: #fff;
            padding: 10px 18px;
            margin-bottom: 8px;
            border-radius: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .historial-item:hover {
            transform: translateX(5px);
        }

        .historial-item.resaltado {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.5);
            transform: scale(1.02);
        }

        .historial-item.resaltado .historial-label,
        .historial-item.resaltado .historial-numero {
            color: #fff !important;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .historial-label {
            color: #666;
            font-size: 13px;
            font-style: italic;
        }

        .historial-numero {
            color: #2196F3;
            font-size: 28px;
            font-weight: bold;
        }

        .historial-vacio {
            text-align: center;
            color: rgba(255,255,255,0.5);
            margin-top: 50px;
            font-style: italic;
        }

        /* Teclado */
        .teclado {
            position: fixed;
            bottom: -100%;
            left: 0;
            right: 0;
            background: rgba(0,0,0,0.98);
            transition: bottom 0.3s ease;
            z-index: 200;
            padding: 15px 15px 35px;
            border-top: 2px solid rgba(255,255,255,0.1);
        }

        .teclado.active {
            bottom: 0;
        }

        .teclado-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .teclado-title {
            color: rgba(255,255,255,0.7);
            font-size: 13px;
            font-style: italic;
        }

        .btn-close {
            background: none;
            border: none;
            color: #ff3b3b;
            font-size: 36px;
            cursor: pointer;
            line-height: 1;
            padding: 0;
        }

        .teclado-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 12px;
            justify-items: center;
            max-width: 380px;
            margin: 0 auto;
        }

        .tecla {
            width: 65px;
            height: 65px;
            background: transparent;
            border: none;
            color: #fff;
            font-size: 36px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.1s;
        }

        .tecla:active {
            transform: scale(0.85);
        }

        .tecla-x {
            color: #ff3b3b !important;
            font-size: 46px !important;
        }

        /* Panel Config */
        .panel-config {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #808080;
            z-index: 300;
            display: none;
            flex-direction: column;
        }

        .panel-config.active {
            display: flex;
        }

        .config-header {
            background: #1a1a1a;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-shrink: 0;
        }

        .config-header h3 {
            font-size: 15px;
            font-weight: normal;
        }

        .config-content {
            flex: 1;
            padding: 10px 15px;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        .section-config { margin-bottom: 8px; }
        .section-title { color: #fff; font-size: 11px; margin-bottom: 6px; font-style: italic; }
        
        .bolillas-carousel {
            display: flex;
            overflow-x: auto;
            gap: 10px;
            padding: 6px 4px;
            scrollbar-width: none;
            margin-bottom: 8px;
        }
        .bolillas-carousel::-webkit-scrollbar { display: none; }
        
        .bolilla-option {
            flex: 0 0 auto;
            cursor: pointer;
            transition: transform 0.2s;
            border: 2px solid rgba(255,255,255,0.3);
            border-radius: 8px;
            padding: 6px;
            position: relative;
        }
        .bolilla-option.selected { border-color: #fff; transform: scale(1.05); }
        
        .bolilla-option::before {
            content: '+';
            position: absolute;
            top: -4px;
            left: -4px;
            width: 20px;
            height: 20px;
            background: rgba(100, 100, 100, 0.9);
            border-radius: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            color: #00ff00;
            font-weight: bold;
        }
        
        .bolilla-mini { width: 42px; height: 42px; border-radius: 50%; }
        .mini-verde { background: radial-gradient(circle at 30% 30%, #7CFC00 0%, #32CD32 40%, #228B22 70%, #006400 100%); }
        .mini-verde-aro { background: radial-gradient(circle at 30% 30%, #7CFC00 0%, #32CD32 40%, #228B22 70%, #006400 100%); box-shadow: 0 0 0 3px #fff inset; }
        .mini-roja { background: radial-gradient(circle at 30% 30%, #ef5350 0%, #f44336 40%, #e53935 70%, #c62828 100%); }
        .mini-multi { background: conic-gradient(from 0deg, #f00, #ff0, #0f0, #0ff, #00f, #f0f, #f00); }
        .mini-oro { background: radial-gradient(circle at 30% 30%, #fff8dc 0%, #ffd700 40%, #daa520 70%, #8b7500 100%); }
        .mini-plata { background: radial-gradient(circle at 30% 30%, #f8f8f8 0%, #c0c0c0 40%, #a9a9a9 70%, #696969 100%); }
        .mini-azul { background: radial-gradient(circle at 30% 30%, #00e5ff 0%, #2196f3 40%, #0d47a1 70%, #002171 100%); }
        .mini-fuego { background: conic-gradient(from 0deg, #ff0 0deg 90deg, #ff4500 90deg 180deg, #f00 180deg 270deg, #ffa500 270deg 360deg); }
        .mini-agua { background: radial-gradient(circle at 40% 40%, #e0ffff 0%, #00bcd4 40%, #0097a7 70%, #006064 100%); }
        .mini-neon { background: radial-gradient(circle at 50% 50%, #39ff14 0%, #0aff9d 50%, #007f5f 100%); box-shadow: 0 0 12px #0aff9d; }
        .mini-sombra { background: radial-gradient(circle at 20% 20%, #555 0%, #333 40%, #111 80%, #000 100%); }
        .mini-arcoiris { background: conic-gradient(from 0deg, red, orange, yellow, green, cyan, blue, violet, red); animation: spinRainbow 5s linear infinite; }
        
        @keyframes spinRainbow { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
        
        .color-section {
            display: flex;
            gap: 20px;
            margin-bottom: 15px;
            justify-content: center;
        }

        .color-item-wrapper {
            flex: 0 0 auto;
            display: flex;
            flex-direction: column;
            gap: 8px;
            align-items: center;
        }

        .color-item-title {
            color: #fff;
            font-size: 18px;
            font-style: italic;
            font-weight: 300;
            margin-bottom: 5px;
        }

        .color-preview { 
            width: 120px;
            height: 80px;
            border: 3px solid #fff;
            border-radius: 12px;
            position: relative;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .color-preview:active {
            transform: scale(0.95);
        }

        .color-preview .plus-icon {
            position: absolute;
            bottom: 8px;
            left: 8px;
            width: 32px;
            height: 32px;
            background: rgba(60, 60, 60, 0.95);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #00ff00;
            font-size: 28px;
            font-weight: bold;
        }

        .fondo-color {
            background: #1976d2;
        }

        .fondo-color .plus-icon {
            display: flex;
        }

        .numeros-color {
            background: #000;
        }

        .numeros-color .plus-icon {
            display: none;
        }
        
        .slider-knob:active {
            cursor: grabbing;
        }
        
        .slider-labels { display: flex; justify-content: space-between; font-size: 9px; font-style: italic; color: rgba(255,255,255,0.5); }
        .slider-labels .active { color: #2196F3; }
        
        .btn-row { display: grid; grid-template-columns: repeat(3, 1fr); gap: 6px; margin-bottom: 8px; }
        .btn-small { 
            background: rgba(80, 80, 80, 0.6);
            border: 2px solid rgba(255,255,255,0.3);
            color: #fff;
            padding: 6px 4px;
            border-radius: 6px;
            font-size: 9px;
            cursor: pointer;
        }
        .btn-small.selected { 
            border-color: #ef5350;
            background: rgba(100, 100, 100, 0.8);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.5);
        }
        
        .idiomas-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 6px; margin-bottom: 8px; }
        
        .share-row { display: grid; grid-template-columns: 1fr 1fr; gap: 8px; margin-bottom: 8px; }
        .btn-share { 
            background: transparent;
            border: 2px solid rgba(255,255,255,0.3);
            color: #fff;
            padding: 8px;
            border-radius: 6px;
            font-size: 10px;
            cursor: pointer;
        }
        .rating-box { 
            background: transparent;
            border: 2px solid rgba(255,255,255,0.3);
            padding: 8px;
            border-radius: 6px;
            text-align: center;
            font-size: 18px;
        }
        
        .restablecer-box { text-align: center; }
        .restablecer-text { color: #ef5350; font-size: 10px; font-style: italic; margin-bottom: 6px; }
        .btn-restablecer { 
            background: #2196F3;
            color: #fff;
            border: none;
            padding: 10px 28px;
            border-radius: 18px;
            font-size: 12px;
            font-style: italic;
            cursor: pointer;
        }
        
        .paleta-colores {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 45vh;
            background: rgba(0,0,0,0.96);
            z-index: 400;
            display: none;
            padding: 12px;
        }

        .paleta-colores.active { display: block; }
        
        .paleta-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }

        .paleta-title { color: #fff; font-size: 13px; }
        
        .paleta-grid {
            display: grid;
            grid-template-columns: repeat(10, 1fr);
            gap: 4px;
            max-height: calc(45vh - 50px);
            overflow-y: auto;
        }

        .color-item {
            aspect-ratio: 1;
            border-radius: 4px;
            cursor: pointer;
            border: 1px solid rgba(255,255,255,0.1);
        }

        @media (min-width: 768px) {
            .app-container { max-width: 480px; margin: 0 auto; }
        }

        /* Slider dificultad */
        .slider-section {
            margin-bottom: 20px;
        }

        .slider-title {
            color: #fff;
            font-size: 18px;
            font-style: italic;
            font-weight: 300;
            text-align: center;
            margin-bottom: 10px;
        }

        .slider-container {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
            max-width: 60%;
            margin-left: auto;
            margin-right: auto;
        }
       
        .slider-label {
            color: rgba(255, 255, 255, 0.7);
            font-size: 14px;
            font-style: italic;
            flex: 0 0 auto;
            text-align: center;
        }

        .slider-label.active {
            color: #1976d2;
            font-weight: bold;
        }

        .slider-track {
            flex: 1;
            height: 10px;
            background: #fff;
            border-radius: 10px;
            position: relative;
            cursor: pointer;
        }

        .slider-knob {
            position: absolute;
            right: 0;
            top: 50%;
            transform: translate(50%, -50%);
            width: 40px;
            height: 40px;
            background: #1976d2;
            border: 3px solid #fff;
            border-radius: 50%;
            cursor: grab;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }

        .slider-knob:active {
            cursor: grabbing;
        }

        .animation-buttons {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            justify-content: center;
        }

        .anim-btn {
            flex: 0 0 auto;
            background: #4a4a4a;
            color: #fff;
            border: 3px solid #666;
            padding: 12px 20px;
            border-radius: 12px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.2s;
            font-weight: 500;
            min-width: 120px;
        }

        .anim-btn:active {
            transform: scale(0.95);
        }

        .anim-btn.selected {
            border-color: #f44336;
            background: #5a5a5a;
            box-shadow: inset 0 3px 10px rgba(0, 0, 0, 0.5);
        }

        .velocity-section {
            margin-bottom: 20px;
        }

        .velocity-title {
            color: #fff;
            font-size: 18px;
            font-style: italic;
            font-weight: 300;
            text-align: center;
            margin-bottom: 10px;
        }

        .velocity-value {
            color: #fff;
            font-weight: bold;
        }

        .velocity-slider {
            width: 80%;
            height: 10px;
            background: #fff;
            border-radius: 10px;
            position: relative;
            cursor: pointer;
            margin: 0 auto;
        }

        .velocity-knob {
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 40px;
            height: 40px;
            background: #0097a7;
            border: 3px solid #fff;
            border-radius: 50%;
            cursor: grab;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }

        .language-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 10px;
            justify-content: center;
        }

        .lang-btn {
            flex: 0 0 auto;
            min-width: calc(20% - 5px);
            max-width: calc(25% - 5px);
            background: #4a4a4a;
            color: #fff;
            border: 3px solid #666;
            padding: 5px 10px;
            border-radius: 12px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.2s;
        }

        .lang-btn:active {
            transform: scale(0.95);
        }

        .lang-btn.selected {
            border-color: #f44336;
            background: #5a5a5a;
            box-shadow: inset 0 3px 10px rgba(0, 0, 0, 0.5);
        }

        .share-rating {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 20px;
            max-width: 80%;
            margin-left: auto;
            margin-right: auto;
        }

        .share-btn {
            background: #4a4a4a;
            color: #fff;
            border: 3px solid #666;
            padding: 12px 10px;
            border-radius: 12px;
            font-size: 14px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            transition: all 0.2s;
        }

        .share-btn:active {
            transform: scale(0.95);
        }

        .rating-box {
            background: #4a4a4a;
            border: 3px solid #666;
            padding: 12px 10px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .share-message {
            color: #fff;
            font-size: 14px;
            text-align: center;
            margin-bottom: 15px;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="app-container" id="appContainer">
        <div class="banner" id="banner">
            <div class="banner-left">
                <span class="banner-empresa" id="bannerEmpresa"><?php echo htmlspecialchars($anuncio_inicial['empresa']); ?></span>
                <span class="banner-text" id="bannerTexto"><?php echo htmlspecialchars($anuncio_inicial['texto']); ?></span>
            </div>
            <button class="banner-btn" id="bannerBtn"><?php echo htmlspecialchars($anuncio_inicial['boton']); ?></button>
        </div>

        <div class="config-section" id="configSection">
            <div class="settings-icon" onclick="abrirConfig()">
                <svg viewBox="0 0 24 24"><path d="M19.14,12.94c0.04-0.3,0.06-0.61,0.06-0.94c0-0.32-0.02-0.64-0.07-0.94l2.03-1.58c0.18-0.14,0.23-0.41,0.12-0.61 l-1.92-3.32c-0.12-0.22-0.37-0.29-0.59-0.22l-2.39,0.96c-0.5-0.38-1.03-0.7-1.62-0.94L14.4,2.81c-0.04-0.24-0.24-0.41-0.48-0.41 h-3.84c-0.24,0-0.43,0.17-0.47,0.41L9.25,5.35C8.66,5.59,8.12,5.92,7.63,6.29L5.24,5.33c-0.22-0.08-0.47,0-0.59,0.22L2.74,8.87 C2.62,9.08,2.66,9.34,2.86,9.48l2.03,1.58C4.84,11.36,4.8,11.69,4.8,12s0.02,0.64,0.07,0.94l-2.03,1.58 c-0.18,0.14-0.23,0.41-0.12,0.61l1.92,3.32c0.12,0.22,0.37,0.29,0.59,0.22l2.39-0.96c0.5,0.38,1.03,0.7,1.62,0.94l0.36,2.54 c0.05,0.24,0.24,0.41,0.48,0.41h3.84c0.24,0,0.44-0.17,0.47-0.41l0.36-2.54c0.59-0.24,1.13-0.56,1.62-0.94l2.39,0.96 c0.22,0.08,0.47,0,0.59-0.22l1.92-3.32c0.12-0.22,0.07-0.47-0.12-0.61L19.14,12.94z M12,15.6c-1.98,0-3.6-1.62-3.6-3.6 s1.62-3.6,3.6-3.6s3.6,1.62,3.6,3.6S13.98,15.6,12,15.6z"/></svg>
            </div>

            <div class="config-grid">
                <div class="config-item">
                    <div class="config-label">desde</div>
                    <div class="config-box" id="boxDesde" onclick="abrirTeclado('desde')">
                        <div class="config-value" id="valDesde"></div>
                    </div>
                </div>
                <div class="config-item">
                    <div class="config-label">hasta</div>
                    <div class="config-box" id="boxHasta" onclick="abrirTeclado('hasta')">
                        <div class="config-value" id="valHasta"></div>
                    </div>
                </div>
                <div class="config-item">
                    <div class="config-label">repetir</div>
                    <div class="config-box" id="boxRep" onclick="abrirTeclado('repetir')">
                        <div class="config-value" id="valRep"></div>
                    </div>
                </div>
            </div>

            <div class="controls-row">
                <div class="limitar-container">
                    <span class="limitar-text">limitar</span>
                    <div class="toggle" id="toggleLimitar" onclick="toggleLimitar()">
                        <div class="toggle-knob"></div>
                    </div>
                </div>
                <button class="btn-reiniciar" onclick="reiniciarSinConfirmar()">reiniciar</button>
            </div>
        </div>

        <div class="bolillero" id="bolillero" onclick="handleBolilleroClick(event)">
            <div class="bolilla-container" onclick="sortear(); event.stopPropagation();">
                <div class="bolilla" id="bolilla">
                    <div class="bolilla-ring"></div>
                    <div class="numero" id="numero">0</div>
                </div>
                <div class="mensaje-badge" id="mensajeBadge">establecer numeros desde hasta</div>
            </div>
            <div class="descripcion" id="desc">establecer numeros desde hasta</div>
            <button class="btn-automatico" id="btnAutomatico" onclick="modoAutomatico(); event.stopPropagation();">automatico</button>
            
            <!-- Ganadores DENTRO del bolillero, justo debajo del botón automático -->
            <div class="ganadores-fila" id="ganadoresFila">
                <!-- Los ganadores se agregan dinámicamente aquí -->
            </div>
        </div>
    </div>

    <div class="icons-bottom" id="iconsBottom">
        <div class="icon-btn icon-lapiz" onclick="mostrarControles()">✏️</div>
        <div class="icon-btn icon-flecha" onclick="abrirHistorial()">›</div>
    </div>

    <div class="panel-historial" id="panelHistorial">
        <div class="historial-header">
            <h3>Historial de Sorteos</h3>
            <button class="btn-close-historial" onclick="cerrarHistorial()">×</button>
        </div>
        <div class="historial-content" id="historialContent">
            <div class="historial-vacio">No hay sorteos aún</div>
        </div>
    </div>

    <div class="teclado" id="teclado">
        <div class="teclado-header">
            <span class="teclado-title" id="campoActivo">desde</span>
        </div>
        <div class="teclado-grid">
            <button class="tecla" onclick="tecla(1)">1</button>
            <button class="tecla" onclick="tecla(2)">2</button>
            <button class="tecla" onclick="tecla(3)">3</button>
            <button class="tecla tecla-x" onclick="borrar()">×</button>
            <button class="tecla" onclick="tecla(4)">4</button>
            <button class="tecla" onclick="tecla(5)">5</button>
            <button class="tecla" onclick="tecla(6)">6</button>
            <button class="tecla" onclick="tecla(0)">0</button>
            <button class="tecla" onclick="tecla(7)">7</button>
            <button class="tecla" onclick="tecla(8)">8</button>
            <button class="tecla" onclick="tecla(9)">9</button>
        </div>
    </div>

    <div class="panel-config" id="panelConfig">
        <div class="config-header">
            <h3>Configuración</h3>
            <button class="btn-close" onclick="cerrarConfig()">×</button>
        </div>
        <div class="config-content">
            <div class="section-config">
                <div class="bolillas-carousel">
                    <div class="bolilla-option" onclick="selBolilla(1)"><div class="bolilla-mini mini-verde"></div></div>
                    <div class="bolilla-option selected" onclick="selBolilla(2)"><div class="bolilla-mini mini-verde-aro"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(3)"><div class="bolilla-mini mini-roja"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(4)"><div class="bolilla-mini mini-multi"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(5)"><div class="bolilla-mini mini-oro"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(6)"><div class="bolilla-mini mini-plata"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(7)"><div class="bolilla-mini mini-azul"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(8)"><div class="bolilla-mini mini-fuego"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(9)"><div class="bolilla-mini mini-agua"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(10)"><div class="bolilla-mini mini-neon"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(11)"><div class="bolilla-mini mini-sombra"></div></div>
                    <div class="bolilla-option" onclick="selBolilla(12)"><div class="bolilla-mini mini-arcoiris"></div></div>
                </div>
            </div>

            <div class="section-config">
                <div class="color-section">
                    <div class="color-item-wrapper">
                        <div class="color-item-title">fondo</div>
                        <div class="color-preview fondo-color" id="fondoPreview" onclick="abrirPaletaFondo()">
                            <div class="plus-icon">+</div>
                        </div>
                    </div>
                    <div class="color-item-wrapper">
                        <div class="color-item-title">numeros</div>
                        <div class="color-preview numeros-color" id="numerosPreview" onclick="abrirPaletaNumeros()"></div>
                    </div>
                </div>
            </div>

            <div class="slider-section">
                <div class="slider-title">dificultad</div>
                <div class="slider-container">
                    <div class="slider-label">facil</div>
                    <div class="slider-track">
                        <div class="slider-knob"></div>
                    </div>
                    <div class="slider-label active">dificil</div>
                </div>
            </div>

            <div class="animation-buttons">
                <button class="anim-btn">animacion 1</button>
                <button class="anim-btn selected">animacion 2</button>
                <button class="anim-btn">animacion 3</button>
            </div>

            <div class="velocity-section">
                <div class="velocity-title">velocidad <span class="velocity-value">2.0x</span></div>
                <div class="velocity-slider">
                    <div class="velocity-knob"></div>
                </div>
            </div>

            <div class="language-buttons">
                <button class="lang-btn">default</button>
                <button class="lang-btn">english</button>
                <button class="lang-btn selected">espanol</button>
                <button class="lang-btn">portugues</button>
            </div>

            <div class="share-message">comparte y calificanos para seguir mejorando</div>

            <div class="share-rating">
                <button class="share-btn">
                    share
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="white">
                        <path d="M18,16.08C17.24,16.08 16.56,16.38 16.04,16.85L8.91,12.7C8.96,12.47 9,12.24 9,12C9,11.76 8.96,11.53 8.91,11.3L15.96,7.19C16.5,7.69 17.21,8 18,8A3,3 0 0,0 21,5A3,3 0 0,0 18,2A3,3 0 0,0 15,5C15,5.24 15.04,5.47 15.09,5.7L8.04,9.81C7.5,9.31 6.79,9 6,9A3,3 0 0,0 3,12A3,3 0 0,0 6,15C6.79,15 7.5,14.69 8.04,14.19L15.16,18.34C15.11,18.55 15.08,18.77 15.08,19C15.08,20.61 16.39,21.91 18,21.91C19.61,21.91 20.92,20.61 20.92,19A2.92,2.92 0 0,0 18,16.08Z"/>
                    </svg>
                </button>
                <div class="rating-box">⭐⭐⭐⭐⭐</div>
            </div>

            <div class="restablecer-box">
                <div class="restablecer-text">restablece el juego anterior</div>
                <button class="btn-restablecer" onclick="restablecerJuego()">restablecer</button>
            </div>
        </div>
    </div>

    <div class="paleta-colores" id="paletaColores">
        <div class="paleta-header">
            <div class="paleta-title" id="paletaTitulo">Color</div>
            <button class="btn-close" onclick="cerrarPaleta()">×</button>
        </div>
        <div class="paleta-grid" id="paletaGrid"></div>
    </div>
<script>
        // Slider dificultad
        const sliderTrack = document.querySelector('.slider-track');
        const sliderKnob = document.querySelector('.slider-knob');
        let isDragging = false;

        sliderKnob.addEventListener('mousedown', () => isDragging = true);
        sliderKnob.addEventListener('touchstart', () => isDragging = true);

        document.addEventListener('mousemove', handleDrag);
        document.addEventListener('touchmove', handleDrag);

        document.addEventListener('mouseup', () => isDragging = false);
        document.addEventListener('touchend', () => isDragging = false);

        function handleDrag(e) {
            if (!isDragging) return;
            
            const rect = sliderTrack.getBoundingClientRect();
            const x = (e.clientX || e.touches[0].clientX) - rect.left;
            const percentage = Math.max(0, Math.min(100, (x / rect.width) * 100));
            
            sliderKnob.style.right = `${100 - percentage}%`;
            
            const labels = document.querySelectorAll('.slider-label');
            if (percentage < 50) {
                labels[0].classList.add('active');
                labels[1].classList.remove('active');
            } else {
                labels[0].classList.remove('active');
                labels[1].classList.add('active');
            }
        }

        // Velocity slider
        const velocitySlider = document.querySelector('.velocity-slider');
        const velocityKnob = document.querySelector('.velocity-knob');
        const velocityValue = document.querySelector('.velocity-value');
        let isDraggingVelocity = false;

        velocityKnob.addEventListener('mousedown', () => isDraggingVelocity = true);
        velocityKnob.addEventListener('touchstart', () => isDraggingVelocity = true);

        document.addEventListener('mousemove', handleVelocityDrag);
        document.addEventListener('touchmove', handleVelocityDrag);

        document.addEventListener('mouseup', () => isDraggingVelocity = false);
        document.addEventListener('touchend', () => isDraggingVelocity = false);

        function handleVelocityDrag(e) {
            if (!isDraggingVelocity) return;
            
            const rect = velocitySlider.getBoundingClientRect();
            const x = (e.clientX || e.touches[0].clientX) - rect.left;
            const percentage = Math.max(0, Math.min(100, (x / rect.width) * 100));
            
            velocityKnob.style.left = `${percentage}%`;
            
            const velocity = (0.5 + (percentage / 100) * 3.5).toFixed(1);
            velocityValue.textContent = velocity + 'x';
        }

        // Botones de animación
        document.querySelectorAll('.anim-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                document.querySelectorAll('.anim-btn').forEach(b => b.classList.remove('selected'));
                btn.classList.add('selected');
            });
        });

        // Botones de idioma
        document.querySelectorAll('.lang-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                document.querySelectorAll('.lang-btn').forEach(b => b.classList.remove('selected'));
                btn.classList.add('selected');
            });
        });

        const anuncios = <?php echo json_encode($anuncios); ?>;
        let anuncioActual = 0;

        function rotarAnuncio() {
            anuncioActual = (anuncioActual + 1) % anuncios.length;
            const anuncio = anuncios[anuncioActual];
            
            const banner = document.getElementById('banner');
            banner.style.opacity = '0';
            
            setTimeout(() => {
                document.getElementById('bannerEmpresa').textContent = anuncio.empresa;
                document.getElementById('bannerTexto').textContent = anuncio.texto;
                document.getElementById('bannerBtn').textContent = anuncio.boton;
                document.getElementById('bannerBtn').style.background = anuncio.color;
                banner.style.opacity = '1';
            }, 300);
        }

        setInterval(rotarAnuncio, 8000);

        function mostrarMensaje(texto) {
            const badge = document.getElementById('mensajeBadge');
            badge.textContent = texto;
            badge.classList.add('visible');
            
            setTimeout(() => {
                badge.classList.remove('visible');
            }, 3000);
        }

        // 🔊 SISTEMA DE SONIDOS CON CAMPANAS Y APLAUSOS
        let audioContext = null;

        // Inicializar el contexto de audio al primer clic (compatibilidad iOS/Safari)
        function inicializarAudio() {
            if (!audioContext) {
                audioContext = new (window.AudioContext || window.webkitAudioContext)();
                console.log("🔊 Audio Context inicializado");
            }
            if (audioContext.state === 'suspended') {
                audioContext.resume();
            }
        }
        
     function reproducirSonidoCelebracion() {
    // Sonidos de celebración gratuitos de Mixkit
    const sonidosCelebracion = [
        // Opción 1: Aplausos y celebración
        'https://assets.mixkit.co/active_storage/sfx/2018/2018-preview.mp3',
        
        // Opción 2: Fanfarria de victoria
        'https://assets.mixkit.co/active_storage/sfx/2000/2000-preview.mp3',
        
        // Opción 3: Efecto de logro/victoria
        'https://assets.mixkit.co/active_storage/sfx/1435/1435-preview.mp3',
        
        // Opción 4: Campanas de victoria
        'https://assets.mixkit.co/active_storage/sfx/2013/2013-preview.mp3'
    ];
    
    // Usar el primer sonido (puedes cambiar el índice)
    reproducirAudioURL(sonidosCelebracion[0]);
}

// Función para reproducir audio desde URL
function reproducirAudioURL(url) {
    const audio = new Audio(url);
    audio.volume = 0.7; // Volumen al 70%
    
    audio.play().catch(error => {
        console.error('Error al reproducir sonido:', error);
        // Si falla, usar sonido sintetizado como respaldo
        reproducirSonidoRespaldo();
    });
}

// Sonido de respaldo (sintético) en caso de que falle la carga
function reproducirSonidoRespaldo() {
    if (!audioContext) {
        audioContext = new (window.AudioContext || window.webkitAudioContext)();
    }
    
    const now = audioContext.currentTime;
    
    // Acorde simple de victoria
    [523.25, 659.25, 783.99].forEach((freq, i) => {
        const osc = audioContext.createOscillator();
        const gain = audioContext.createGain();
        
        osc.connect(gain);
        gain.connect(audioContext.destination);
        
        osc.type = 'sine';
        osc.frequency.value = freq;
        
        gain.gain.setValueAtTime(0, now + i * 0.1);
        gain.gain.linearRampToValueAtTime(0.2, now + i * 0.1 + 0.05);
        gain.gain.exponentialRampToValueAtTime(0.01, now + i * 0.1 + 0.5);
        
        osc.start(now + i * 0.1);
        osc.stop(now + i * 0.1 + 0.5);
    });
}

// ===== ALTERNATIVA: USAR FREESOUND (requiere API key) =====
// Para obtener API key gratis: https://freesound.org/apiv2/apply/

function reproducirSonidoFreesound() {
    // Algunos IDs de sonidos de celebración en Freesound:
    // 270404 - Crowd cheering
    // 397355 - Victory fanfare
    // 456966 - Applause
    // 341695 - Win sound effect
    
    const API_KEY = 'TU_API_KEY_AQUI'; // Obtener gratis en freesound.org
    const soundId = 456966; // Victory fanfare
    
    fetch(`https://freesound.org/apiv2/sounds/${soundId}/?token=${API_KEY}`)
        .then(response => response.json())
        .then(data => {
            const audio = new Audio(data.previews['preview-hq-mp3']);
            audio.volume = 0.7;
            audio.play();
        })
        .catch(error => {
            console.error('Error:', error);
            reproducirSonidoRespaldo();
        });
}


        const colores = ['#FFF','#E8E8E8','#C0C0C0','#A8A8A8','#808080','#585858','#383838','#000','#006400','#00008B','#800000','#808000','#008000','#008080','#000080','#800080','#00F','#800080','#8B0000','#FF8C00','#0F0','#32CD32','#00CED1','#1E90FF','#00F','#8B008B','#FF1493','#F00','#FF4500','#FFD700','#ADFF2F','#0F0','#0FF','#00BFFF','#00F','#8B00FF','#F0F','#FF1493','#F00','#FF6347','#FFA500','#FF0','#7FFF00','#0F0','#00FA9A','#0FF','#00BFFF','#1E90FF','#4169E1','#9370DB','#DA70D6','#FF69B4','#FFA07A','#FFD700','#F0E68C','#ADFF2F','#90EE90','#98FB98','#AFEEEE','#87CEEB','#87CEFA','#B0C4DE','#DDA0DD','#FFB6C1'];
        
        let valores = {desde:'', hasta:'', rep:''};
        let campoActivo = 'desde';
        let limitar = false;
        let girando = false;
        let sorteoActual = 0;
        let numerosSorteados = [];
        let historialSorteos = [];
        let tipoColorActual = '';
        let juegoIniciado = false;
        let contadorBolillas = 0;
        let contadorGanadores = 0;

        mostrarMensaje('establecer numeros desde hasta');

        function abrirTeclado(campo) {
            if (campo === 'repetir') campo = 'rep';
            campoActivo = campo;
            document.getElementById('teclado').classList.add('active');
            document.getElementById('campoActivo').textContent = campo === 'rep' ? 'repetir' : campo;
            
            document.querySelectorAll('.config-box').forEach(box => box.classList.remove('active'));
            document.getElementById('box' + (campo === 'rep' ? 'Rep' : campo.charAt(0).toUpperCase() + campo.slice(1))).classList.add('active');
        }

        function cerrarTeclado() {
            document.getElementById('teclado').classList.remove('active');
            document.querySelectorAll('.config-box').forEach(box => box.classList.remove('active'));
        }

        document.addEventListener('click', function(e) {
            const teclado = document.getElementById('teclado');
            const configBoxes = document.querySelectorAll('.config-box');
            
            if (teclado.classList.contains('active')) {
                const clickEnTeclado = teclado.contains(e.target);
                const clickEnConfigBox = Array.from(configBoxes).some(box => box.contains(e.target));
                
                if (!clickEnTeclado && !clickEnConfigBox) {
                    cerrarTeclado();
                }
            }
        });

        document.getElementById('teclado').addEventListener('click', function(e) {
            e.stopPropagation();
        });

        function tecla(num) {
            if (!valores[campoActivo]) valores[campoActivo] = "";
            if (valores[campoActivo].length < 4) {
                valores[campoActivo] += num;
                actualizarDisplay();
            }
        }

        function borrar() {
            valores[campoActivo] = valores[campoActivo].slice(0, -1);
            actualizarDisplay();
        }

        function actualizarDisplay() {
            document.getElementById('valDesde').textContent = valores.desde;
            document.getElementById('valHasta').textContent = valores.hasta;
            document.getElementById('valRep').textContent = valores.rep;
        }

        function toggleLimitar() {
            limitar = !limitar;
            document.getElementById('toggleLimitar').classList.toggle('active');
        }

        function handleBolilleroClick(event) {
            if (juegoIniciado && !event.target.closest('.bolilla-container')) {
                mostrarControles();
            }
        }

        function mostrarControles() {
            if (juegoIniciado) {
                document.getElementById('configSection').classList.remove('hidden');
                document.getElementById('bolillero').classList.remove('expanded');
                document.getElementById('btnAutomatico').classList.remove('hidden');
                document.getElementById('iconsBottom').classList.remove('hidden');
                
                mostrarMensaje('establecer numeros desde hasta');
                juegoIniciado = false;
            }
        }

        function abrirHistorial() {
            actualizarHistorial();
            document.getElementById('panelHistorial').classList.add('active');
        }

        function cerrarHistorial() {
            document.getElementById('panelHistorial').classList.remove('active');
        }

        function actualizarHistorial() {
            const container = document.getElementById('historialContent');
            
            if (historialSorteos.length === 0) {
                container.innerHTML = '<div class="historial-vacio">No hay sorteos aún</div>';
                return;
            }

            let html = '';
            historialSorteos.forEach((item, index) => {
                html += `
                    <div class="historial-item" data-numero="${item.numero}" onclick="resaltarNumero(${item.numero})">
                        <span class="historial-label">al azar n ${index + 1}</span>
                        <span class="historial-numero">${item.numero}</span>
                    </div>
                `;
            });

            container.innerHTML = html;
        }

        function resaltarNumero(numeroSeleccionado) {
            const items = document.querySelectorAll('.historial-item');
            
            const yaResaltado = Array.from(items).some(item => 
                parseInt(item.dataset.numero) === numeroSeleccionado && 
                item.classList.contains('resaltado')
            );
            
            if (yaResaltado) {
                items.forEach(item => {
                    if (parseInt(item.dataset.numero) === numeroSeleccionado) {
                        item.classList.remove('resaltado');
                    }
                });
            } else {
                items.forEach(item => item.classList.remove('resaltado'));
                
                items.forEach(item => {
                    if (parseInt(item.dataset.numero) === numeroSeleccionado) {
                        item.classList.add('resaltado');
                    }
                });
            }
        }

        function agregarGanadorAFila(numero, posicion) {
            const fila = document.getElementById('ganadoresFila');
            
            const ganadorDiv = document.createElement('div');
            ganadorDiv.className = 'ganador-item';
            ganadorDiv.innerHTML = `
                <div class="ganador-item-label">${posicion} completo${posicion > 1 ? 's' : ''}</div>
                <div class="ganador-item-cuadro">
                    <div class="ganador-item-numero">${numero}</div>
                </div>
            `;
            
            fila.appendChild(ganadorDiv);
        }

        async function sortear() {
            if (girando) return;
            
            const desde = parseInt(valores.desde);
            const hasta = parseInt(valores.hasta);
            const repetir = parseInt(valores.rep);
            
            if (!desde || !hasta || !repetir) {
                mostrarMensaje('establecer números desde / hasta');
                return;
            }
            
            if (desde >= hasta) {
                alert('El número "hasta" debe ser mayor que "desde"');
                return;
            }

            if (!juegoIniciado) {
                document.getElementById('configSection').classList.add('hidden');
                document.getElementById('bolillero').classList.add('expanded');
                document.getElementById('btnAutomatico').classList.add('hidden');
                document.getElementById('iconsBottom').classList.add('hidden');
                document.getElementById('mensajeBadge').classList.remove('visible');
                
               
                juegoIniciado = true;
            }
            
            girando = true;
            const bolilla = document.getElementById('bolilla');
            const display = document.getElementById('numero');
            
            bolilla.classList.add('girando');
            
            try {
                const response = await fetch('../ajax/ejecutar_sorteo.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ desde, hasta, repetir })
                });

                if (!response.ok) throw new Error("Error");
                const data = await response.json();
                
                console.log('Respuesta del servidor:', data);

                if (data.error) {
                    alert("Error: " + data.mensaje);
                    bolilla.classList.remove('girando');
                    girando = false;
                    return;
                }

                if (data.juego_terminado) {
                    bolilla.classList.remove('girando');
                    girando = false;
                    mostrarMensaje('¡JUEGO COMPLETADO!');
                    alert(`¡Juego Terminado!\n\nGanadores: ${data.ganadores.join(', ')}`);
                    return;
                }

                const numFinal = data.numero;
                let ticks = 0;
                const intervalo = setInterval(() => {
                    display.textContent = Math.floor(Math.random() * (hasta - desde + 1)) + desde;
                    ticks++;
                    
                    if (ticks > 30) {
                        clearInterval(intervalo);
                        display.textContent = numFinal;
                        numerosSorteados.push(numFinal);
                        historialSorteos.push({ numero: numFinal, timestamp: new Date() });
                        sorteoActual = data.sorteo_actual;
                        
                        contadorBolillas++;
                        
                        setTimeout(() => {
                            bolilla.classList.remove('girando');
                            girando = false;

                            mostrarMensaje(`bolilla ${contadorBolillas}`);

                            if (data.es_nuevo_ganador) {
                                console.log('¡NUEVO GANADOR!', numFinal);
                                
                                if ('vibrate' in navigator) {
                                    navigator.vibrate([200, 100, 200, 100, 400]);
                                }

                                reproducirSonidoCelebracion();

                                contadorGanadores++;
                                agregarGanadorAFila(numFinal, contadorGanadores);
                            }

                            if ('speechSynthesis' in window) {
                                const utterance = new SpeechSynthesisUtterance(numFinal.toString());
                                utterance.lang = 'es-ES';
                                utterance.rate = 0.85;
                                speechSynthesis.speak(utterance);
                            }
                        }, 500);
                    }
                }, 70);

            } catch (error) {
                console.error('Error:', error);
                bolilla.classList.remove('girando');
                girando = false;
                alert('Error al sortear');
            }
        }

        function reiniciarSinConfirmar() {
            valores = {desde:'', hasta:'', rep:''};
            sorteoActual = 0;
            numerosSorteados = [];
            historialSorteos = [];
            juegoIniciado = false;
            contadorBolillas = 0;
            contadorGanadores = 0;
            document.getElementById('numero').textContent = '0';
            
            document.getElementById('ganadoresFila').innerHTML = '';
            
            document.getElementById('configSection').classList.remove('hidden');
            document.getElementById('bolillero').classList.remove('expanded');
            document.getElementById('btnAutomatico').classList.remove('hidden');
            document.getElementById('iconsBottom').classList.remove('hidden');
            mostrarMensaje('establecer numeros desde hasta');
            actualizarDisplay();
            
            fetch('../ajax/limpiar_sesion.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' }
            });
        }

        function modoAutomatico() {
            if (!valores.desde || !valores.hasta || !valores.rep) {
                alert('Configura desde/hasta/repetir primero');
                return;
            }
            alert('Modo automático activado');
        }

        function abrirConfig() { document.getElementById('panelConfig').classList.add('active'); }
        function cerrarConfig() { document.getElementById('panelConfig').classList.remove('active'); }
        
        function generarPaleta() {
            const grid = document.getElementById('paletaGrid');
            grid.innerHTML = '';
            colores.forEach(c => {
                const div = document.createElement('div');
                div.className = 'color-item';
                div.style.background = c;
                div.onclick = () => seleccionarColor(c);
                grid.appendChild(div);
            });
        }

        function abrirPaletaFondo() {
            tipoColorActual = 'fondo';
            document.getElementById('paletaTitulo').textContent = 'Color Fondo';
            generarPaleta();
            document.getElementById('paletaColores').classList.add('active');
        }

        function abrirPaletaNumeros() {
            tipoColorActual = 'numeros';
            document.getElementById('paletaTitulo').textContent = 'Color Números';
            generarPaleta();
            document.getElementById('paletaColores').classList.add('active');
        }

        function cerrarPaleta() { document.getElementById('paletaColores').classList.remove('active'); }

        function seleccionarColor(color) {
            if (tipoColorActual === 'fondo') {
                document.getElementById('appContainer').style.background = color;
                document.getElementById('fondoPreview').style.background = color;
            } else if (tipoColorActual === 'numeros') {
                document.getElementById('numero').style.color = color;
                document.getElementById('numerosPreview').style.background = color;
            }
            cerrarPaleta();
        }

        function selBolilla(num) {
            document.querySelectorAll('.bolilla-option').forEach(o => o.classList.remove('selected'));
            document.querySelectorAll('.bolilla-option')[num-1].classList.add('selected');
            
            const bolilla = document.querySelector('.bolilla');
            const ring = document.querySelector('.bolilla-ring');
            ring.style.display = 'none';

            const gradientes = {
                1: 'radial-gradient(circle at 30% 30%, #7CFC00 0%, #32CD32 40%, #228B22 70%, #006400 100%)',
                2: 'radial-gradient(circle at 30% 30%, #7CFC00 0%, #32CD32 40%, #228B22 70%, #006400 100%)',
                3: 'radial-gradient(circle at 30% 30%, #ef5350 0%, #f44336 40%, #e53935 70%, #c62828 100%)',
                4: 'conic-gradient(from 0deg, #f00 0deg 60deg, #ff0 60deg 120deg, #0f0 120deg 180deg, #0ff 180deg 240deg, #00f 240deg 300deg, #f0f 300deg 360deg)',
                5: 'radial-gradient(circle at 30% 30%, #fff8dc 0%, #ffd700 40%, #daa520 70%, #8b7500 100%)',
                6: 'radial-gradient(circle at 30% 30%, #f8f8f8 0%, #c0c0c0 40%, #a9a9a9 70%, #696969 100%)',
                7: 'radial-gradient(circle at 30% 30%, #00e5ff 0%, #2196f3 40%, #0d47a1 70%, #002171 100%)',
                8: 'conic-gradient(from 0deg, #ff0 0deg 90deg, #ff4500 90deg 180deg, #f00 180deg 270deg, #ffa500 270deg 360deg)',
                9: 'radial-gradient(circle at 40% 40%, #e0ffff 0%, #00bcd4 40%, #0097a7 70%, #006064 100%)',
                10: 'radial-gradient(circle at 50% 50%, #39ff14 0%, #0aff9d 50%, #007f5f 100%)',
                11: 'radial-gradient(circle at 20% 20%, #555 0%, #333 40%, #111 80%, #000 100%)',
                12: 'conic-gradient(from 0deg, red, orange, yellow, green, cyan, blue, violet, red)'
            };

            bolilla.style.background = gradientes[num];
            if (num === 2) ring.style.display = 'block';
        }

        function restablecerJuego() {
            reiniciarSinConfirmar();
            cerrarConfig();
        }

        actualizarDisplay();

        let vozHabilitada = false;

        document.addEventListener('click', () => {
            inicializarAudio();
            
            if (!vozHabilitada && 'speechSynthesis' in window) {
                const test = new SpeechSynthesisUtterance("Voz activada");
                test.lang = 'es-ES';
                test.volume = 0;
                window.speechSynthesis.speak(test);
                vozHabilitada = true;
                console.log("🔊 Voz y Audio desbloqueados");
            }
        });
    </script>
</body>
</html>