/**
 * BOLILLERO - JavaScript Principal
 * Manejo de eventos y UI
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // Elementos del DOM
    const inputDesde = document.getElementById('desde');
    const inputHasta = document.getElementById('hasta');
    const inputRepetir = document.getElementById('repetir');
    const btnReiniciar = document.getElementById('btnReiniciar');
    const btnAutomatico = document.getElementById('btnAutomatico');
    const bolillaNumero = document.getElementById('bolillaNumero');
    const bolillaTexto = document.getElementById('bolillaTexto');
    
    // Estado de la aplicación
    let configuracionActual = {
        desde: null,
        hasta: null,
        repetir: null
    };
    
    // Validar y actualizar configuración
    function validarConfiguracion() {
        const desde = parseInt(inputDesde.value);
        const hasta = parseInt(inputHasta.value);
        const repetir = parseInt(inputRepetir.value);
        
        if (isNaN(desde) || isNaN(hasta) || isNaN(repetir)) {
            btnAutomatico.disabled = true;
            bolillaTexto.textContent = 'establecer numeros desde hasta';
            return false;
        }
        
        if (desde >= hasta) {
            btnAutomatico.disabled = true;
            bolillaTexto.textContent = 'el número "hasta" debe ser mayor';
            return false;
        }
        
        if (repetir < 1 || repetir > 10) {
            btnAutomatico.disabled = true;
            bolillaTexto.textContent = 'repeticiones entre 1 y 10';
            return false;
        }
        
        const rango = hasta - desde + 1;
        if (rango < 5) {
            btnAutomatico.disabled = true;
            bolillaTexto.textContent = 'mínimo 5 números de rango';
            return false;
        }
        
        configuracionActual = { desde, hasta, repetir };
        btnAutomatico.disabled = false;
        bolillaTexto.textContent = `sortear del ${desde} al ${hasta}, ${repetir} veces`;
        
        return true;
    }
    
    // Event listeners para inputs
    inputDesde.addEventListener('input', validarConfiguracion);
    inputHasta.addEventListener('input', validarConfiguracion);
    inputRepetir.addEventListener('input', validarConfiguracion);
    
    // Botón reiniciar
    btnReiniciar.addEventListener('click', function() {
        inputDesde.value = '';
        inputHasta.value = '';
        inputRepetir.value = '';
        bolillaNumero.textContent = '0';
        bolillaTexto.textContent = 'establecer numeros desde hasta';
        btnAutomatico.disabled = true;
        
        // Animación de reinicio
        const bolilla = document.getElementById('bolilla');
        bolilla.classList.add('aparecer');
        setTimeout(() => bolilla.classList.remove('aparecer'), 500);
    });
    
    // Botón automático - iniciar sorteo
    btnAutomatico.addEventListener('click', function() {
        if (!validarConfiguracion()) {
            alert('Por favor completa la configuración correctamente');
            return;
        }
        
        // Iniciar sorteo
        iniciarSorteo(configuracionActual);
    });
    
    // Botón editar (placeholder)
    document.getElementById('btnEditar').addEventListener('click', function() {
        // Funcionalidad futura
        console.log('Editar');
    });
    
    // Botón atrás
    document.getElementById('btnAtras').addEventListener('click', function() {
        if (confirm('¿Deseas volver? Se perderá la configuración actual.')) {
            window.location.reload();
        }
    });
    
    // Prevenir zoom en inputs en iOS
    const inputs = document.querySelectorAll('input[type="number"]');
    inputs.forEach(input => {
        input.addEventListener('focus', function() {
            if (/iPhone|iPad|iPod/i.test(navigator.userAgent)) {
                this.style.fontSize = '16px';
            }
        });
    });
    
    // Efecto de feedback táctil
    const botones = document.querySelectorAll('button, .btn-config, .icon-btn');
    botones.forEach(btn => {
        btn.addEventListener('touchstart', function() {
            if (navigator.vibrate) {
                navigator.vibrate(10);
            }
        });
    });
    
});
