/**
 * BOLILLERO - Animaciones
 * Efectos visuales para la bolilla
 */

/**
 * Animar bolilla principal
 */
function animarBolilla(numero) {
    const bolilla = document.getElementById('bolilla');
    const bolillaNumero = document.getElementById('bolillaNumero');
    
    // Agregar clase de rotación
    bolilla.classList.add('girando');
    
    // Cambiar número después de medio ciclo
    setTimeout(() => {
        bolillaNumero.textContent = numero;
    }, 750);
    
    // Remover animación
    setTimeout(() => {
        bolilla.classList.remove('girando');
    }, 1500);
}

/**
 * Efecto de pulso en la bolilla
 */
function pulsarBolilla(elemento) {
    if (!elemento) return;
    
    elemento.style.animation = 'none';
    setTimeout(() => {
        elemento.style.animation = 'pulsar 0.5s ease-in-out';
    }, 10);
}

/**
 * Animación de confeti (ganador)
 */
function lanzarConfeti() {
    // Implementación básica de confeti
    const colores = ['#FFD700', '#FF6B6B', '#4ECDC4', '#45B7D1', '#96CEB4'];
    const cantidad = 50;
    
    for (let i = 0; i < cantidad; i++) {
        crearConfeti(colores[Math.floor(Math.random() * colores.length)]);
    }
}

/**
 * Crear partícula de confeti
 */
function crearConfeti(color) {
    const confeti = document.createElement('div');
    confeti.style.position = 'fixed';
    confeti.style.width = '10px';
    confeti.style.height = '10px';
    confeti.style.backgroundColor = color;
    confeti.style.left = Math.random() * window.innerWidth + 'px';
    confeti.style.top = '-10px';
    confeti.style.opacity = '1';
    confeti.style.transform = 'rotate(' + Math.random() * 360 + 'deg)';
    confeti.style.zIndex = '9999';
    confeti.style.pointerEvents = 'none';
    confeti.style.borderRadius = '2px';
    
    document.body.appendChild(confeti);
    
    // Animar caída
    const duracion = 2000 + Math.random() * 1000;
    const rotacion = Math.random() * 720 - 360;
    const desplazamientoX = Math.random() * 200 - 100;
    
    confeti.animate([
        {
            transform: `translate(0, 0) rotate(0deg)`,
            opacity: 1
        },
        {
            transform: `translate(${desplazamientoX}px, ${window.innerHeight + 10}px) rotate(${rotacion}deg)`,
            opacity: 0
        }
    ], {
        duration: duracion,
        easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)'
    });
    
    // Remover después de la animación
    setTimeout(() => {
        confeti.remove();
    }, duracion);
}

/**
 * Efecto de brillo en número ganador
 */
function brillarNumero(elemento) {
    if (!elemento) return;
    
    elemento.style.textShadow = '0 0 20px rgba(255, 215, 0, 1), 0 0 40px rgba(255, 215, 0, 0.5)';
    
    setTimeout(() => {
        elemento.style.textShadow = '';
    }, 1000);
}

/**
 * Animación de entrada suave
 */
function entradaSuave(elemento) {
    if (!elemento) return;
    
    elemento.style.opacity = '0';
    elemento.style.transform = 'scale(0.8)';
    
    setTimeout(() => {
        elemento.style.transition = 'all 0.5s ease-out';
        elemento.style.opacity = '1';
        elemento.style.transform = 'scale(1)';
    }, 10);
}

/**
 * Animación de salida
 */
function salidaSuave(elemento, callback) {
    if (!elemento) return;
    
    elemento.style.transition = 'all 0.3s ease-in';
    elemento.style.opacity = '0';
    elemento.style.transform = 'scale(0.8)';
    
    setTimeout(() => {
        if (callback) callback();
    }, 300);
}

/**
 * Shake (sacudir) elemento
 */
function shake(elemento) {
    if (!elemento) return;
    
    elemento.animate([
        { transform: 'translateX(0)' },
        { transform: 'translateX(-10px)' },
        { transform: 'translateX(10px)' },
        { transform: 'translateX(-10px)' },
        { transform: 'translateX(10px)' },
        { transform: 'translateX(0)' }
    ], {
        duration: 500,
        easing: 'ease-in-out'
    });
}

/**
 * Efecto de onda (ripple) en botones
 */
function rippleEffect(event) {
    const button = event.currentTarget;
    const ripple = document.createElement('span');
    
    const diameter = Math.max(button.clientWidth, button.clientHeight);
    const radius = diameter / 2;
    
    const rect = button.getBoundingClientRect();
    ripple.style.width = ripple.style.height = `${diameter}px`;
    ripple.style.left = `${event.clientX - rect.left - radius}px`;
    ripple.style.top = `${event.clientY - rect.top - radius}px`;
    ripple.classList.add('ripple');
    
    const rippleStyle = document.createElement('style');
    rippleStyle.textContent = `
        .ripple {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.6);
            transform: scale(0);
            animation: ripple-animation 0.6s ease-out;
            pointer-events: none;
        }
        @keyframes ripple-animation {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }
    `;
    
    if (!document.getElementById('ripple-style')) {
        rippleStyle.id = 'ripple-style';
        document.head.appendChild(rippleStyle);
    }
    
    button.style.position = 'relative';
    button.style.overflow = 'hidden';
    
    const existingRipple = button.querySelector('.ripple');
    if (existingRipple) {
        existingRipple.remove();
    }
    
    button.appendChild(ripple);
    
    setTimeout(() => {
        ripple.remove();
    }, 600);
}

// Agregar efecto ripple a todos los botones
document.addEventListener('DOMContentLoaded', function() {
    const botones = document.querySelectorAll('button, .btn-config, .icon-btn');
    botones.forEach(btn => {
        btn.addEventListener('click', rippleEffect);
    });
});

/**
 * Animación de carga (loader)
 */
function mostrarLoader(elemento) {
    if (!elemento) return;
    
    const loader = document.createElement('div');
    loader.className = 'loader';
    loader.innerHTML = `
        <div class="spinner"></div>
    `;
    
    const loaderStyle = document.createElement('style');
    loaderStyle.textContent = `
        .loader {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid rgba(255, 255, 255, 0.1);
            border-top-color: #4CAF50;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    `;
    
    if (!document.getElementById('loader-style')) {
        loaderStyle.id = 'loader-style';
        document.head.appendChild(loaderStyle);
    }
    
    elemento.appendChild(loader);
}

/**
 * Ocultar loader
 */
function ocultarLoader(elemento) {
    if (!elemento) return;
    
    const loader = elemento.querySelector('.loader');
    if (loader) {
        loader.remove();
    }
}
