<?php
/**
 * BOLILLERO - Configuraciones Generales
 * PHP 8.0.30
 */

// Iniciar sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Zona horaria
date_default_timezone_set('America/Lima');

// Configuraciones generales
define('SITE_NAME', 'Bolillero');
define('SITE_URL', 'https://munisanjuan.gob.pe/game/bolillero');
define('BASE_PATH', __DIR__ . '/../');

 
// Manejo de errores (desarrollo)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Para producción, comentar las líneas anteriores y usar:
// error_reporting(0);
// ini_set('display_errors', 0);

// Incluir base de datos
require_once BASE_PATH . 'config/database.php';

// Funciones helper
function redirect($url) {
    header("Location: " . SITE_URL . $url);
    exit;
}

function json_response($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function sanitize_input($data) {
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

function get_client_ip() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
    }
}

function get_user_agent() {
    return $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';
}

function get_or_create_session_id() {
    if (!isset($_SESSION['session_id'])) {
        $_SESSION['session_id'] = bin2hex(random_bytes(16));
    }
    return $_SESSION['session_id'];
}
?>