<?php
require_once '../config/config.php';

header('Content-Type: application/json');

try {
    $session_id = get_or_create_session_id();
    $db = getDB();
    
    $stmt = $db->prepare("
        UPDATE sesiones_sorteo 
        SET estado = 'cancelado'
        WHERE session_id = :session_id 
        AND estado = 'activo'
    ");
    $stmt->execute(['session_id' => $session_id]);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['error' => true, 'mensaje' => $e->getMessage()]);
}
?>
